# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdtype import *
from .sdvalue import *
from .sdarray import *
from .sdapiobject import *
from .sdtype import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueArray(SDValue):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueArray
        """
        super(SDValueArray, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(itemType : SDType, size : int) -> Optional[SDValueArray]:
        """
        Create a new SDValueArray

        :param itemType: The type of the item
        :param size: The initial size of the array. Usually 0
        """
        outSDValueArray = ctypes.c_void_p()
        _res = sd.getContext().SDValueArray_sNew(itemType.mHandle, size, ctypes.byref(outSDValueArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueArray, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueArray.value, ownHandle=True)

    def getSize(self) -> int:
        """
        Get the size of the array

        """
        outSize = ctypes.c_size_t()
        _res = self.mAPIContext.SDValueArray_getSize(self.mHandle, ctypes.byref(outSize))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outSize.value

    def getItem(self, index : int) -> Optional[SDValue]:
        """
        Get the SDValue at the specified index

        :param index: The index of the item to retrieve. Must be lower than getSize().
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDValueArray_getItem(self.mHandle, index, ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def setItem(self, index : int, sdValue : SDValue) -> None:
        """
        Set the item value at the specified index

        :param index: The index of the item to replace. Must be lower than getSize().
        :param sdValue: The item that will replace the current one at the specified position
        """
        _res = self.mAPIContext.SDValueArray_setItem(self.mHandle, index, sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def pushBack(self, sdValue : SDValue) -> None:
        """
        Append the given SDValue at the end of the array. The size of the array is increased by 1.

        :param sdValue: The new item to add
        """
        _res = self.mAPIContext.SDValueArray_pushBack(self.mHandle, sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def get(self) -> SDArray[SDValue]:
        """
        Get the whole array as a SDArray

        """
        outSDArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDValueArray_get(self.mHandle, ctypes.byref(outSDArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDArray.value, ownHandle=True)

